#include <bits/stdc++.h>
#define int long long
#define pb push_back
#define mp make_pair
#define all(x) (x).begin(),(x).end()
#define fi first
#define sc second
#define endl "\n"
#define pii pair<int,int>

using namespace std;

const int MAXN = 2e5+5;
const int mod7 = 1e9+7;
const long long inf = 1e18;
vector<int> niz(MAXN);
vector<int> allsums(MAXN);
vector<int> cnt(MAXN);
unordered_map<int, priority_queue<int>> pozicije;
int ukupnisum = 0;
std::mt19937_64 rng((unsigned)chrono::high_resolution_clock::now().time_since_epoch().count());

struct nod
{
    pii k;
    int velicina = 1;
    int sum;
    int pr;
    nod *l = NULL;
    nod *r = NULL;
    nod(pii n) : k(n),pr((int)(rng()&0xffffffff)), sum(n.fi){}
};

nod* r = NULL;

int findSize(nod* n)
{
     return n ? n->velicina : 0;
}
int findSum(nod* n)
{
     return n ? n->sum : 0;
}

void update(nod* n)
{
    if(!n) return;
    n->velicina = findSize(n->l) + findSize(n->r) + 1;
    n->sum = findSum(n->l) + findSum(n->r) + n->k.fi;
}

void split(nod *n, pii x, nod *&levi, nod *&desni)
{
    if(!n)
    {
        levi=desni=NULL;
        return;
    }
    if(n->k <= x)
    {
        split(n->r, x, n->r, desni);
        levi = n;
    }
    else
        {
        split(n->l, x, levi, n->l);
        desni = n;
    }
    update(n);
}

void add(nod* &n, nod* x)
{
    if(!n)
    {
        n = x;
        return;
    }
    if(x->pr > n->pr)
    {
        split(n, x->k, x->l, x->r);
        n = x;
    }
    else
    {
        if(x->k <= n->k) add(n->l, x);
        else add(n->r, x);
    }
    update(n);
}

nod* mrg(nod* levi, nod* desni)
{
    if(!levi) return desni;
    if(!desni) return levi;
    if(levi->pr > desni->pr)
    {
        levi->r = mrg(levi->r, desni);
        update(levi);
        return levi;
    }
    else
    {
        desni->l = mrg(levi, desni->l);
        update(desni);
        return desni;
    }
}

void del(nod* &n,pii x)
{
    if(!n) return;
    if(n->k == x)
    {
        nod *tr = n;
        n = mrg(n->l, n->r);
        delete tr;
    }
    else
    {
        if(x <= n->k) del(n->l, x);
        else del(n->r, x);
    }
    update(n);
}


int query(nod* n, int x)
{
    if(!n || x<=0)return 0;
    int desni = findSize(n->r);
    if(desni >= x)return query(n->r, x);
    int finalrez = findSum(n->r) + n->k.fi;
    int trazi = x - desni - 1;
    if(trazi)finalrez+=query(n->l, trazi);
    return finalrez;
}

void update(int index, int v)
{
    int tr = niz[index];
    if(tr == v)return;
    del(r, {allsums[tr], tr});
    ukupnisum-= allsums[tr];
    cnt[tr]--;
    if(cnt[tr])
    {
        allsums[tr] = tr*cnt[tr];
        add(r, new nod({allsums[tr], tr}));
        ukupnisum+= allsums[tr];
    }
    else allsums[tr] = 0;
    if(cnt[v])
    {
        del(r, {allsums[v], v});
        ukupnisum-= allsums[v];
    }
    cnt[v]++;
    allsums[v] = cnt[v]*v;
    add(r, new nod({allsums[v], v}));
    ukupnisum+=allsums[v];
    niz[index] = v;

}

void build()
{
    for(int i=1; i<=MAXN; i++)if(allsums[i])add(r, new nod(mp(allsums[i], i)));
}


signed main()
{
    ios_base::sync_with_stdio(false),cin.tie(0), cout.tie(0);
    int tt=1;
    //cin >> tt;
    while(tt--)
    {
        int n,q;
        cin >> n >> q;
        for(int i=1; i<=n; i++)
        {
            cin >> niz[i];
            allsums[niz[i]] += niz[i];
            cnt[niz[i]]++;
            ukupnisum+=niz[i];
            pozicije[niz[i]].push(i);
        }
        build();
        while(q--)
        {
            int c,x;cin >> c >> x;
            if(c&1)
            {
                int najvecih = n-x;
                if(najvecih<=0)cout << ukupnisum << endl;
                else
                {
                    najvecih = min(najvecih, findSize(r));
                    cout << ukupnisum - query(r, najvecih) << endl;
                }
            }
            else
            {
                int v;cin >> v;
                update(x, v);
            }
        }
    }
}